function [psf_new,factor] = conflux(psf,im,numit,dampar,subsmpl)
%This little function make sure the psf used for LR deconv preserves flux
%of the image.
%Synatax:   [psf_new,factor] = conflux(psf,im,numit,[],[]); 
%Input:     psf = the point spread function
%           im = the original image
%           numit = number of iteration for deconvolution.
%           dampar = the threshold deviation of the resulting image from 
%               the original image (in terms of the standard deviation of 
%               Poisson noise) below which damping occurs
%           subsmpl =  denotes subsampling and is used when the PSF is
%               given on a grid that is SUBSMPL times finer than the image.
%           note: for numit dampar & subsmpl, for default use []
%Output:    psf_new = the new psf.
%           factor = the divsor of the psf

%lets get started
factor = 0;     %initiate factor
while 1
    if factor==0        %first time
        j1 = deconvlucy(im2double(im),psf,numit,im2double(dampar),[],[],im2double(subsmpl));     %deconvolve
        factor = sum(sum(im))/sum(sum(j1));                     %how conserving is the psf
        if factor<1.01 && factor>0.99       %with in 1% close enough
            psf_new = psf;      %no change
            break       %exit
        end
    else                %not first time
        psf_new = psf./factor;      %modify the psf
        j1 = deconvlucy(im2double(im),psf_new,numit,im2double(dampar),[],[],im2double(subsmpl));     %deconvolve
        factor_tmp = sum(sum(im))/sum(sum(j1));
        if factor_tmp<1.01 && factor_tmp>0.99;       %with in 1% close enough
            break       %exit
        else            %not good enough
            factor = factor*factor_tmp;     %modify the factor
            %keyboard
        end
    end        
end